//=============================================================================
// PB GameReplicationInfo.
//=============================================================================
class GRI extends TournamentGameReplicationInfo;

var string Maps[255];
var int GoalTeamScore;
var int FragLimit;
var int TimeLimit;
var localized string SupportStringTrailer;
var int someint;
var bool bVictorious, bRoundStarted;

//PB custom variables:
var int Lives;	//Easy=200,Medium=150,Hard=100
var int Round;	//keeps track of the current round

replication
{
	reliable if ( Role == ROLE_Authority )
		Lives,Round,bVictorious,bRoundStarted,
		Maps,
		FragLimit, TimeLimit, GoalTeamScore;
		
	reliable if ( (Role == ROLE_Authority) && bNetInitial )
		someint;
}

simulated function PostBeginPlay()
{
	FragLimit = 0;
	TimeLimit = 0;
	GoalTeamScore = 0;
	bVictorious=False;
	bRoundStarted=False;
	Super.PostBeginPlay();
}

simulated function string GetOrderString(PlayerReplicationInfo PRI)
{
	return FreelanceString;
}

defaultproperties
{
Lives=200
Round=1
bVictorious=False
bRoundStarted=True
}
